import { logger } from 'tachyon-logger';
import type {
  TwitchGraphQLResponse,
  TwitchPayloadExtensions,
} from '../../types';
import { logServicesFromResponse } from '.';

jest.mock('tachyon-logger', () => ({ logger: { debug: jest.fn() } }));
const mockLoggerDebug = logger.debug as jest.Mock;

describe(logServicesFromResponse, () => {
  it('safely noops without extensions', () => {
    logServicesFromResponse({} as TwitchGraphQLResponse);
    expect(mockLoggerDebug).not.toHaveBeenCalled();
  });

  it('safely noops without queries', () => {
    logServicesFromResponse({ extensions: {} } as TwitchGraphQLResponse);
    expect(mockLoggerDebug).not.toHaveBeenCalled();
  });

  it('extracts and dedupes services', () => {
    const extensions: TwitchPayloadExtensions = {
      queries: [
        {
          end: '2020-12-09T02:08:56.806500315Z',
          method: 'service.Cartman.GetAuthorizationToken',
          start: '2020-12-09T02:08:56.790300311Z',
        },
        {
          end: '2020-12-09T02:08:56.833919425Z',
          method: 'service.Users.GetUsers',
          start: '2020-12-09T02:08:56.823905396Z',
        },
        {
          end: '2020-12-09T02:08:56.848458769Z',
          method: 'service.Flix.Homepage',
          start: '2020-12-09T02:08:56.807603718Z',
        },
        {
          end: '2020-12-09T02:08:56.848458769Z',
          method: 'service.Users.GetUsers',
          start: '2020-12-09T02:08:56.807603718Z',
        },
      ],
    };

    logServicesFromResponse({ extensions } as TwitchGraphQLResponse);
    expect(mockLoggerDebug).toHaveBeenCalledWith(
      expect.objectContaining({
        context: {
          services: 'Cartman,Users,Flix',
        },
      }),
    );
  });
});
