import { useRef } from 'react';
import type { GQLEdges, NonNullNodesWithEndCursor } from 'tachyon-utils-twitch';
import { reduceToNonNullNodesWithEndCursor } from 'tachyon-utils-twitch';
import type { GraphQLNode } from '../types';

export function useRefetchList<Node extends GraphQLNode>(
  edges: GQLEdges<Node>,
): NonNullNodesWithEndCursor<Node> & { noMore: boolean } {
  const endCursor = useRef<string | null>(null);
  const noMore = useRef(false);
  const nodes = useRef<Node[]>([]);
  const seen = useRef(new Set<string>());

  const { endCursor: newEndCursor, nodes: newNodes } =
    reduceToNonNullNodesWithEndCursor(edges);

  // if we have the same endCursor as last time, do nothing
  if (newEndCursor !== endCursor.current) {
    endCursor.current = newEndCursor;
    if (newNodes.length === 0) {
      // if there are no nodes, set the noMore flag to prevent refetches
      noMore.current = true;
    } else {
      // filter out nodes we've already seen
      const filteredNodes = newNodes.filter((node) => {
        if (!seen.current.has(node.id)) {
          seen.current.add(node.id);
          return true;
        }
        return false;
      });
      nodes.current = nodes.current.concat(filteredNodes);
    }
  }

  return {
    endCursor: endCursor.current,
    noMore: noMore.current,
    nodes: nodes.current,
  };
}
