import type { Request, Response } from 'express';
import {
  GLOBAL_COOKIE_NAMES,
  createTachyonDeviceID,
} from 'tachyon-utils-twitch';
import {
  getAndExtendCookieValueOnServer,
  setCookieValueOnServer,
} from '../cookies';

/**
 * Gets the common twitch device ID from a server request object.
 *
 * @param req a server request object
 */
export function getDeviceIDOnServer(
  req: Request,
  res: Response,
): string | undefined {
  return getAndExtendCookieValueOnServer({
    name: GLOBAL_COOKIE_NAMES.DEVICE_ID_COOKIE_NAME,
    req,
    res,
  });
}

/**
 * Generates a tachyon device ID and persists it to a server response object.
 *
 * @param res a server response object
 * @return the generated device id
 */
export function createDeviceIDOnServer(res: Response): string {
  const deviceID = createTachyonDeviceID();
  setCookieValueOnServer({
    name: GLOBAL_COOKIE_NAMES.DEVICE_ID_COOKIE_NAME,
    res,
    value: deviceID,
  });
  return deviceID;
}
