import type { Request, Response } from 'express';
import {
  GLOBAL_COOKIE_NAMES,
  TACHYON_DEVICE_ID_PREFIX,
  createTachyonDeviceID,
} from 'tachyon-utils-twitch';
import {
  getAndExtendCookieValueOnServer,
  setCookieValueOnServer,
} from '../cookies';
import { createDeviceIDOnServer, getDeviceIDOnServer } from '.';

jest.mock('../cookies', () => ({
  getAndExtendCookieValueOnServer: jest.fn(),
  setCookieValueOnServer: jest.fn(),
}));
const mockGetCookieValueOnServer = getAndExtendCookieValueOnServer as jest.Mock;
const mockSetCookieValueOnServer = setCookieValueOnServer as jest.Mock;

describe('device id', () => {
  beforeEach(() => {
    mockGetCookieValueOnServer.mockReset();
    mockSetCookieValueOnServer.mockReset();
  });

  describe(getDeviceIDOnServer, () => {
    it('returns a device id cookie value', () => {
      const id = createTachyonDeviceID();
      mockGetCookieValueOnServer.mockImplementationOnce(() => id);
      const req = {} as Request;
      const res = {} as Response;

      expect(getDeviceIDOnServer(req, res)).toEqual(id);
      expect(mockGetCookieValueOnServer).toHaveBeenCalledWith({
        name: GLOBAL_COOKIE_NAMES.DEVICE_ID_COOKIE_NAME,
        req,
        res,
      });
    });
  });

  describe(createDeviceIDOnServer, () => {
    it('generates a device id and sets an appropriate cookie', () => {
      const res = {} as Response;
      const id = createDeviceIDOnServer(res);
      expect(id.startsWith(TACHYON_DEVICE_ID_PREFIX)).toBeTruthy();

      expect(mockSetCookieValueOnServer).toHaveBeenCalledWith({
        name: GLOBAL_COOKIE_NAMES.DEVICE_ID_COOKIE_NAME,
        res,
        value: id,
      });
    });
  });
});
