import type { ExperimentBucket } from 'tachyon-experiments';
import { stringToSha256 } from 'tachyon-utils-crypto';

// From: https://manage.fastly.com/configure/services/5qKeZ5T0TKLd66StWKgM9p/versions/67/data/dictionaries
// Manually kept in sync (duplicated from the values in the URL above)
// istanbul ignore next: trivial
function edgeDictionary(lookup: number): ExperimentBucket {
  if (lookup < 10) {
    return 'a';
  } else if (lookup < 125) {
    return 'b';
  } else if (lookup < 250) {
    return 'c';
  } else if (lookup < 375) {
    return 'd';
  } else if (lookup < 500) {
    return 'e';
  } else if (lookup < 625) {
    return 'f';
  } else if (lookup < 750) {
    return 'g';
  } else if (lookup < 875) {
    return 'h';
  }
  return 'i';
}

/** * Generates an experiment bucket from a device ID.
 * Operates exactly the same as the VCL code running in Fastly.
 *
 * @param deviceID unique ID representing a user device
 * @return experiment bucket
 */
export function generateExperimentBucketFromDeviceID(
  deviceID: string,
): ExperimentBucket {
  //   set var.hash = digest.hash_sha256(req.http.Cookie:unique_id);
  //   set var.bucket = std.strtol(regsub(var.hash, "(\w{8,8}).*", "\1"), 16);
  //   set var.bucket %= 1000; # modulo arithmetic to assign between 1000 buckets
  //
  // #Edge dictionary lookup. We take the number generated from the above modulo and assign it a letter 'a' - 'i'.
  // #We currently have 1000 values in the dictionary.
  //  set var.experimenttreatment = table.lookup(bucket, var.bucket);
  //  set req.http.Experiment-Bucket = var.experimenttreatment;
  //  https://git.xarth.tv/CPE-Ops/fastly-config/blob/main/mobile/experiment.vcl#L53-L68
  const hash = stringToSha256(deviceID);
  const key = parseInt(hash.slice(0, 8), 16) % 1000;
  return edgeDictionary(key);
}
