import { readFileSync } from 'fs';
import ini from 'ini';

// istanbul ignore next: trivial
/**
 * Reads an ini-formatted file and returns the contents as a nested object.
 * Any errors are not caught as there is no way to provide a safe generic
 * fallback and thus the responsibility of the caller.
 */
export function readIniFile<T extends {} = {}>(path: string): T {
  return ini.parse(readFileSync(path, 'utf-8')) as T;
}
