import type { Request } from 'express';
import { parseUrl } from 'query-string';
import { RedirectionCode } from 'tachyon-type-library';
import { badRequestManager } from '.';

jest.mock('tachyon-logger', () => ({ logger: { log: jest.fn() } }));

describe(badRequestManager, () => {
  const badRequestRedirectPath = '/yikes';
  const dynamicPathnames = ['/[login]'];

  const configuredManager = badRequestManager({
    badRequestRedirectPath,
    dynamicPathnames,
  });

  it.each(['/finargot%E2%E0%F0%E4%FB', '/%', ...dynamicPathnames])(
    'redirects to a 404 page for %s',
    (url: string) => {
      const { query, url: path } = parseUrl(url);
      const request = {
        header: jest.fn(),
        path,
        query,
      } as any as Request;

      expect(configuredManager(request)).toEqual({
        location: badRequestRedirectPath,
        statusCode: RedirectionCode.TemporaryRedirect,
      });
    },
  );

  it.each([
    '/lirik',
    '/foo/bar?boop=baz',
    '/howdy%20',
    '/api12324',
    '/foo/api',
  ])(
    'it does not redirect to an app error page for valid path %s',
    (url: string) => {
      const { query, url: path } = parseUrl(url);
      const request = {
        path,
        query,
      } as Request;

      expect(configuredManager(request)).toBeUndefined();
    },
  );
});
