import type { Request } from 'express';
import { HTTPStatusCode } from 'tachyon-type-library';
import type {
  RedirectCommand,
  RedirectManager,
} from '../redirectManagerExpressAdapter';

export interface ChannelAliasMiddlewareOpts {
  channelAliases: Record<string, string>;
}

export function channelAliasManager({
  channelAliases,
}: ChannelAliasMiddlewareOpts): RedirectManager {
  return ({ path }: Request): RedirectCommand => {
    // drop leading / from path
    const target = channelAliases[path.slice(1).toLowerCase()];
    if (target) {
      return {
        location: `/${target}`,
        statusCode: HTTPStatusCode.Found,
      };
    }
  };
}
