import type { Request } from 'express';
import { HTTPStatusCode } from 'tachyon-type-library';
import { channelAliasManager } from '.';

describe(channelAliasManager, () => {
  const channelAliases = {
    derek: 'therealderekt',
  };

  const configuredManager = channelAliasManager({ channelAliases });

  it('redirects when matching an alias', () => {
    expect(configuredManager({ path: '/derek' } as Request)).toEqual({
      location: '/therealderekt',
      statusCode: HTTPStatusCode.Found,
    });
  });

  it('redirects when matching an alias with different casing', () => {
    expect(configuredManager({ path: '/DEREK' } as Request)).toEqual({
      location: '/therealderekt',
      statusCode: HTTPStatusCode.Found,
    });
  });

  it('does not redirect when not matching an alias', () => {
    expect(
      configuredManager({ path: '/monstercat' } as Request),
    ).toBeUndefined();
  });
});
