import type { RequestHandler } from 'express';
import type { BadRequestMiddlewareOpts } from './badRequestManager';
import { badRequestManager } from './badRequestManager';
import type { ChannelAliasMiddlewareOpts } from './channelAliasManager';
import { channelAliasManager } from './channelAliasManager';
import type { PageAlias, PageAliasMiddlewareOpts } from './pageAliasManager';
import { pageAliasManager } from './pageAliasManager';
import { redirectManagerExpressAdapter } from './redirectManagerExpressAdapter';
import type { RedirectToDesktopWebMiddlewareOpts } from './redirectToDesktopWebManager';
import { redirectToDesktopWebManager } from './redirectToDesktopWebManager';

export type {
  BadRequestMiddlewareOpts,
  ChannelAliasMiddlewareOpts,
  PageAlias,
  PageAliasMiddlewareOpts,
  RedirectToDesktopWebMiddlewareOpts,
};

export type TachyonServerMiddlewareOpts = {
  badRequestMiddleware?: BadRequestMiddlewareOpts;
  channelAliasMiddleware?: ChannelAliasMiddlewareOpts;
  pageAliasMiddleware?: PageAliasMiddlewareOpts;
  redirectToDesktopWebMiddleware?: RedirectToDesktopWebMiddlewareOpts;
};

export function tachyonServerMiddleware({
  badRequestMiddleware,
  channelAliasMiddleware,
  pageAliasMiddleware,
  redirectToDesktopWebMiddleware,
}: TachyonServerMiddlewareOpts): RequestHandler[] {
  const handlers: RequestHandler[] = [];

  if (badRequestMiddleware) {
    handlers.push(
      redirectManagerExpressAdapter(badRequestManager(badRequestMiddleware)),
    );
  }

  if (channelAliasMiddleware) {
    handlers.push(
      redirectManagerExpressAdapter(
        channelAliasManager(channelAliasMiddleware),
      ),
    );
  }
  if (pageAliasMiddleware) {
    handlers.push(
      redirectManagerExpressAdapter(pageAliasManager(pageAliasMiddleware)),
    );
  }
  if (redirectToDesktopWebMiddleware) {
    handlers.push(
      redirectManagerExpressAdapter(
        redirectToDesktopWebManager(redirectToDesktopWebMiddleware),
      ),
    );
  }

  return handlers;
}
