import type { NextFunction, Request, RequestHandler, Response } from 'express';
import type { RedirectionCode } from 'tachyon-type-library';

export type RedirectCommand =
  | {
      location: string;
      statusCode: RedirectionCode;
    }
  | undefined;

export type RedirectManager = (request: Request) => RedirectCommand;

export function redirectManagerExpressAdapter(
  manager: RedirectManager,
): RequestHandler {
  return (request: Request, response: Response, next: NextFunction): void => {
    const command = manager(request);
    if (command) {
      response.redirect(command.statusCode, command.location);
      response.end();
    } else {
      next();
    }
  };
}
