import type { StringifiableRecord } from 'query-string';
import { stringify } from 'query-string';

/**
 * Returns a formatted Desktop (twitch.tv) URL for a given path and query params.
 * We specify www.twitch.tv as the URL host since requests to twitch.tv will be
 * redirected to the former by the CDN.
 */
export function prepareDesktopUrl(
  path: string,
  queryParams: StringifiableRecord,
): string {
  const preparedPath = path.replace(/^\//, '');

  const url = `https://www.twitch.tv/${preparedPath}`;
  const querystring = stringify(queryParams);

  if (!querystring) {
    return url;
  }

  return `${url}?${querystring}`;
}
