import { prepareDesktopUrl } from '.';

describe(prepareDesktopUrl, () => {
  it('creates a well formatted url', () => {
    expect(prepareDesktopUrl('foo', { hello: 'my_name_is_derek' })).toEqual(
      'https://www.twitch.tv/foo?hello=my_name_is_derek',
    );
  });

  it('strips a leading "/" from a path when assembling the url', () => {
    expect(prepareDesktopUrl('/foo', {})).toEqual(prepareDesktopUrl('foo', {}));
  });

  it('handles empty query params', () => {
    expect(prepareDesktopUrl('foo', {})).toEqual('https://www.twitch.tv/foo');
  });
});
