import { act } from 'react-dom/test-utils';

type VisibilityToggler = {
  background: () => void;
  foreground: () => void;
};

export const visibility = (document: Document): VisibilityToggler => {
  let hidden = false;
  Object.defineProperty(document, 'hidden', { get: () => hidden });

  function changeVisibility(to: boolean): void {
    hidden = !to;
    act(() => {
      document.dispatchEvent(new Event('visibilitychange'));
    });
  }

  const background = () => changeVisibility(false);
  const foreground = () => changeVisibility(true);

  return { background, foreground };
};
