const { resolve } = require('path');
const webpack = require('webpack');

const { name: library } = require('./package.json');

module.exports = function(env = {}) {
  return {
    mode: 'production',
    entry: resolve(__dirname, 'node_modules', 'twitch-tmi.js'),
    resolve: {
      extensions: ['.js'],
    },
    module: {
      rules: [
        {
          test: /\.js$/,
          use: 'babel-loader',
        },
      ],
    },
    output: {
      library,
      filename: 'index.js',
      libraryTarget: 'commonjs2',
      path: resolve(__dirname, 'dist'),
    },
  };
};
