import type { _RefType } from 'relay-runtime';
import type { DeepNonNullableObj, DistributedOmit } from './utility';

/**
 * Allows for isolation of a single type from a GQL union type.
 * @param Type is the desired type to be isolated
 * @param UnionType is the GQL union from generated types
 */
export type IsolateGqlUnionType<Type, UnionType> = Extract<
  UnionType,
  { __typename: Type }
>;

export type NonNullableFragmentData<Fragment> = DeepNonNullableObj<
  OmitRefType<Fragment>
>;

/**
 * Omits Relay's ' $refType' field. This is helpful when extracting
 * generated types from Relay Fragments that are spread with the
 * @relay(mask: false) directive.
 */
export type OmitRefType<Fragment> = DistributedOmit<
  Fragment,
  keyof _RefType<string>
>;
