import type { Primitive } from 'type-fest';

export type TwitchEventProperties = Record<string, Primitive>;

/**
 * The base Twitch event type as defined by data science (and accepted by
 * Spade). This should be extended in consumer projects.
 *
 * **NOTE** since there is no programmatic blueprint schema access this is not
 * strongly typed.
 */
export type TwitchEvent<
  EventName extends string = string,
  Properties extends TwitchEventProperties = TwitchEventProperties,
> = {
  /**
   * The event name defined in BluePrint.
   */
  event: EventName;
  /**
   * The fields sent as part of the event.
   */
  properties?: Properties | undefined;
};
