import type { CamelCase, KebabCase } from 'type-fest';

// type-fest-ext types are ones that are pure expansions of type-fest-based
// logic and could be upstreamed back into that library

type OnlySnakeCaseProperty<Obj extends {}, K extends keyof Obj> = K extends
  | CamelCase<K>
  | KebabCase<K>
  ? never
  : K;

/**
 * Enforces all keys in an object are snake-case, excluding any that are
 * camel-case or kebab-case.
 */
export type OnlySnakeCaseProperties<Obj extends {}> = {
  [K in keyof Obj as OnlySnakeCaseProperty<Obj, K>]: Obj[K];
};
