import type { OnlySnakeCaseProperties } from '.';

type SnakePropertiesTest = OnlySnakeCaseProperties<{
  ['a-b']: boolean;
  aB: boolean;
  a_b: boolean;
}>;

const snakePropertiesSuccess: SnakePropertiesTest = {
  a_b: true,
};
const snakePropertiesKebabError: SnakePropertiesTest = {
  a_b: true,
  // @ts-expect-error: only accept snake
  'a-b': true,
};
const snakePropertiesCamelError: SnakePropertiesTest = {
  a_b: true,
  // @ts-expect-error: only accept snake
  aB: true,
};

// @ts-expect-error: accumulator for dealing with unused declarations
const tests = [
  snakePropertiesSuccess,
  snakePropertiesKebabError,
  snakePropertiesCamelError,
];
