// eslint-disable-next-line import/no-internal-modules
import sha1 from 'crypto-js/sha1';

/**
 * Generates a random number between 0 and 1 using UUID & device ID as a seed.
 *
 * @param UUID Part of the seed for the random number generator.
 * @param deviceID Part of the seed for the random number generator.
 */
export function getRandomValue(UUID: string, deviceID: string): number {
  const hashedRNGseed = sha1(UUID + deviceID);

  return (hashedRNGseed.words[0] >>> 0) / Math.pow(2, 32);
}
