// eslint-disable-next-line import/no-internal-modules
import Base64 from 'crypto-js/enc-base64';
// eslint-disable-next-line import/no-internal-modules
import Utf8 from 'crypto-js/enc-utf8';

/**
 * To make data Spade-compliant the following transforms are applied to an Event:
 * 1. The event must be stringified.
 * 2. The stringified event must be base-64 encoded.
 */
export function spadeifyEvents<EventType extends {}>(
  events: EventType[],
): string {
  const str = JSON.stringify(events);
  const base64 = Base64.stringify(Utf8.parse(str));

  return base64;
}

/**
 * Reverse of spadeifyEvent
 */
export function unspadeifyEvents<EventType extends {}>(
  data: string,
): EventType[] {
  const str = Utf8.stringify(Base64.parse(data));
  const events = JSON.parse(str);

  return events;
}
