# tachyon-utils-mem

Convenience wrappers around the [mem](https://github.com/sindresorhus/mem)
library.

## Installation

```sh
$ yarn add tachyon-utils-mem
```

## Usage

This package exposes three main memoization strategies:

- simple: shallow comparison of first argument to a function
- deep: deep comparison of all arugments to a function
- lead object keys: shallow comparison of the values of specific keys of the
  object that is the first argument to a function

Additionally, there is a custom strategy that lets user build cache keys
themselves based on the functions args.

These strategies come in both bottomless ("all") and limited ("some", via LRU
culling) cache sizes.

Thus, the following functions are available:

- memoizeSimpleAll
- memoizeSimpleSome
- memoizeDeepAll
- memoizeDeepSome
- memoizeLeadObjKeysAll
- memoizeLeadObjKeysSome
- memoizeCustomAll
- memoizeCustomSome
