import { memoizeCustomAll, memoizeCustomSome } from '.';

describe('memoize custom', () => {
  const mockFn = jest.fn((a: { b: number }) => a.b);

  describe(memoizeCustomAll, () => {
    it('caches the return value of multiple function calls', () => {
      const memoFn = memoizeCustomAll(mockFn, {
        cacheKey: (args) => args[0].b,
      });
      expect(memoFn({ b: 1 })).toEqual(1);
      expect(memoFn({ b: 1 })).toEqual(1);
      expect(mockFn).toHaveBeenCalledTimes(1);
      expect(memoFn({ b: 2 })).toEqual(2);
      expect(memoFn({ b: 2 })).toEqual(2);
      expect(mockFn).toHaveBeenCalledTimes(2);
      expect(memoFn({ b: 3 })).toEqual(3);
      expect(memoFn({ b: 3 })).toEqual(3);
      expect(mockFn).toHaveBeenCalledTimes(3);
      expect(memoFn({ b: 2 })).toEqual(2);
      expect(memoFn({ b: 2 })).toEqual(2);
      expect(mockFn).toHaveBeenCalledTimes(3);
      expect(memoFn({ b: 1 })).toEqual(1);
      expect(memoFn({ b: 1 })).toEqual(1);
      expect(mockFn).toHaveBeenCalledTimes(3);
    });
  });

  describe(memoizeCustomSome, () => {
    it('caches the return value of last N unique multiple function calls', () => {
      const memoFn = memoizeCustomSome(mockFn, {
        cacheKey: (args) => args[0].b,
        maxSize: 2,
      });
      expect(memoFn({ b: 1 })).toEqual(1);
      expect(memoFn({ b: 1 })).toEqual(1);
      expect(mockFn).toHaveBeenCalledTimes(1);
      expect(memoFn({ b: 2 })).toEqual(2);
      expect(memoFn({ b: 2 })).toEqual(2);
      expect(mockFn).toHaveBeenCalledTimes(2);
      expect(memoFn({ b: 1 })).toEqual(1);
      expect(memoFn({ b: 1 })).toEqual(1);
      expect(mockFn).toHaveBeenCalledTimes(2);
      expect(memoFn({ b: 3 })).toEqual(3);
      expect(memoFn({ b: 3 })).toEqual(3);
      expect(mockFn).toHaveBeenCalledTimes(3);
      // refreshed by second round
      expect(memoFn({ b: 1 })).toEqual(1);
      expect(memoFn({ b: 1 })).toEqual(1);
      expect(mockFn).toHaveBeenCalledTimes(3);
      expect(memoFn({ b: 2 })).toEqual(2);
      expect(memoFn({ b: 2 })).toEqual(2);
      expect(mockFn).toHaveBeenCalledTimes(4);
      expect(memoFn({ b: 3 })).toEqual(3);
      expect(memoFn({ b: 3 })).toEqual(3);
      expect(mockFn).toHaveBeenCalledTimes(5);
    });

    it('caches just the last unique call with maxSize of 1', () => {
      const memoFn = memoizeCustomSome(mockFn, {
        cacheKey: (args) => args[0].b,
        maxSize: 1,
      });
      expect(memoFn({ b: 1 })).toEqual(1);
      expect(memoFn({ b: 1 })).toEqual(1);
      expect(mockFn).toHaveBeenCalledTimes(1);
      expect(memoFn({ b: 2 })).toEqual(2);
      expect(memoFn({ b: 2 })).toEqual(2);
      expect(mockFn).toHaveBeenCalledTimes(2);
      expect(memoFn({ b: 3 })).toEqual(3);
      expect(memoFn({ b: 3 })).toEqual(3);
      expect(mockFn).toHaveBeenCalledTimes(3);
      expect(memoFn({ b: 2 })).toEqual(2);
      expect(memoFn({ b: 2 })).toEqual(2);
      expect(mockFn).toHaveBeenCalledTimes(4);
      expect(memoFn({ b: 1 })).toEqual(1);
      expect(memoFn({ b: 1 })).toEqual(1);
      expect(mockFn).toHaveBeenCalledTimes(5);
    });
  });
});
