import type {
  MemoizeCustomAllOpts,
  MemoizeCustomSomeOpts,
} from '../memoizeCustom';
import { memoizeCustomAll, memoizeCustomSome } from '../memoizeCustom';

export type MemoizeDeepAllOpts<Args extends unknown[], Ret> = Omit<
  MemoizeCustomAllOpts<Args, Ret>,
  'cacheKey'
>;
/**
 * A memoization function that uses deep comparison of all arguments (via
 * JSON.stringify) to build a cache key and memoize all calls to the function.
 * Since the arguments' equality test here is expensive, this should only be
 * used strategically in place of better options.
 */
export function memoizeDeepAll<Args extends unknown[], Ret>(
  fn: (...args: Args) => Ret,
  opts: MemoizeDeepAllOpts<Args, Ret> = {},
): (...args: Args) => Ret {
  return memoizeCustomAll(fn, { ...opts, cacheKey: JSON.stringify });
}

export type MemoizeDeepSomeOpts<Args extends unknown[], Ret> = Omit<
  MemoizeCustomSomeOpts<Args, Ret>,
  'cacheKey'
>;
/**
 * A memoization function that uses deep comparison of all arguments (via
 * JSON.stringify) to build a cache key and memoize the most recent N unique
 * (according to the specified keys) calls to the wrapped function, with N
 * governed my the maxSize opt value. Since the arguments' equality test here is
 * expensive, this should only be used strategically in place of better options.
 */
export function memoizeDeepSome<Args extends unknown[], Ret>(
  fn: (...args: Args) => Ret,
  opts: MemoizeDeepSomeOpts<Args, Ret>,
): (...args: Args) => Ret {
  return memoizeCustomSome(fn, { ...opts, cacheKey: JSON.stringify });
}
