import { memoizeDeepAll, memoizeDeepSome } from '.';

describe('memoize deep', () => {
  const mockFn = jest.fn((a: { b: number }, c: { d: number }) => a.b + c.d);

  describe(memoizeDeepAll, () => {
    it('caches the return value of multiple function calls with complex arguments', () => {
      const memoFn = memoizeDeepAll(mockFn);
      expect(memoFn({ b: 1 }, { d: 2 })).toEqual(3);
      expect(memoFn({ b: 1 }, { d: 2 })).toEqual(3);
      expect(mockFn).toHaveBeenCalledTimes(1);
      expect(memoFn({ b: 3 }, { d: 4 })).toEqual(7);
      expect(memoFn({ b: 3 }, { d: 4 })).toEqual(7);
      expect(mockFn).toHaveBeenCalledTimes(2);
    });
  });

  describe(memoizeDeepSome, () => {
    it('caches the return value of last N unique function calls with complex arguments', () => {
      const memoFn = memoizeDeepSome(mockFn, { maxSize: 1 });
      expect(memoFn({ b: 1 }, { d: 2 })).toEqual(3);
      expect(memoFn({ b: 1 }, { d: 2 })).toEqual(3);
      expect(mockFn).toHaveBeenCalledTimes(1);
      expect(memoFn({ b: 3 }, { d: 4 })).toEqual(7);
      expect(memoFn({ b: 3 }, { d: 4 })).toEqual(7);
      expect(mockFn).toHaveBeenCalledTimes(2);
      expect(memoFn({ b: 1 }, { d: 2 })).toEqual(3);
      expect(memoFn({ b: 1 }, { d: 2 })).toEqual(3);
      expect(mockFn).toHaveBeenCalledTimes(3);
    });
  });
});
