/**
 * This files exists because we don't want to import the prop-types
 * library, which is normally required for using context (for
 * contextTypes). Since TS takes care of proper type enforcement,
 * this is an empty function that always returns null, which is
 * what prop-types validator functions do when they have
 * successfully validated. Just set all members of a contextType
 * object to this function.
 *
 * Also included is the ContextTypes type mapper that quickly
 * generates a valid shape for the contextTypes and childContextTypes
 * static properties.
 *
 * Together, they would be used like:
 *
 *     interface ActualContext {
 *       foo: number;
 *     }
 *
 *     const contextTypes: ContextTypes<ActualContext> = {
 *       foo: contextTypeValidator,
 *     };
 *
 * replacing ActualContext with whatever you want to return from
 * getChildContext().
 */

export type ContextTypes<T> = { [K in keyof T]: () => null };

export function contextTypeValidator(): null {
  return null;
}
