import type { ComponentType } from 'react';

/**
 * This provides a consistent way to get a React component's name by:
 * 1. Display name
 * 1. `name` property
 * 1. fallback to 'component'
 *
 * @param Component The component to get the name of.
 * @returns A name for the ocmponent.
 */
export function getComponentName(Component: ComponentType<any>): string {
  return Component.displayName || Component.name || 'Component';
}
