import type { MemoizeLeadObjKeysAllOpts } from 'tachyon-utils-mem';
import { memoizeLeadObjKeysAll } from 'tachyon-utils-mem';
import { useConstCallback } from '../useConst';

// Memoize so that remounting a seen card does not send duplicate events.
// Discussion: https://twitch.slack.com/archives/GSS7CKM0D/p1580514257007700
export function useCallbackMemoizedByKey<T extends {}>(
  callback: (params: T) => void,
  memoObjKeys: MemoizeLeadObjKeysAllOpts<[T], null>,
): (params: T) => void {
  return useConstCallback(memoizeLeadObjKeysAll(callback, memoObjKeys));
}
