import { act, renderHook } from '@testing-library/react-hooks';
import { useCallbackMemoizedByKey } from '.';

const trackItemMock = jest.fn();
describe(useCallbackMemoizedByKey, () => {
  const params1 = { uniqueKey: '1' };
  const params2 = { uniqueKey: '2' };

  beforeEach(() => {
    jest.resetAllMocks();
  });
  it('invokes the onImpression handler once per unique targetKeys', () => {
    const { result: trackItemHook } = renderHook(() =>
      useCallbackMemoizedByKey(trackItemMock, { targetKeys: ['uniqueKey'] }),
    );
    act(() => {
      trackItemHook.current(params1);
      trackItemHook.current(params2);
      trackItemHook.current(params1);
    });

    expect(trackItemMock).toHaveBeenCalledTimes(2);
  });

  it('does not invoke the onImpression handler when the consumer is remounted', () => {
    const { rerender, result: trackItemHook } = renderHook(() =>
      useCallbackMemoizedByKey(trackItemMock, { targetKeys: ['uniqueKey'] }),
    );

    act(() => {
      trackItemHook.current(params1);
      trackItemHook.current(params2);
    });

    rerender();

    act(() => {
      trackItemHook.current(params1);
      trackItemHook.current(params2);
    });

    expect(trackItemMock).toHaveBeenCalledTimes(2);
  });
});
