import { act, renderHook } from '@testing-library/react-hooks';
import { useConst, useConstCallback } from '.';

describe(useConst, () => {
  it('returns a constant value', () => {
    const initialProps = {};
    const { rerender, result } = renderHook((p) => useConst(p), {
      initialProps,
    });
    expect(result.current).toEqual(initialProps);

    act(() => rerender({}));
    expect(result.current).toEqual(initialProps);
  });

  it('runs generator only once', () => {
    const initialProps = jest.fn(() => 1);
    const { rerender, result } = renderHook((p) => useConst(p), {
      initialProps,
    });
    expect(initialProps).toHaveBeenCalledTimes(1);
    expect(result.current).toEqual(1);

    act(() => rerender(initialProps));
    expect(initialProps).toHaveBeenCalledTimes(1);
    expect(result.current).toEqual(1);
  });
});

describe(useConstCallback, () => {
  it('returns a constant value', () => {
    const initialProps = jest.fn();
    const { rerender, result } = renderHook((p) => useConstCallback(p), {
      initialProps,
    });
    expect(result.current).toEqual(initialProps);
    expect(initialProps).toHaveBeenCalledTimes(0);

    act(() => rerender(jest.fn()));
    expect(result.current).toEqual(initialProps);
    expect(initialProps).toHaveBeenCalledTimes(0);
  });
});
