import { useRef } from 'react';
import type { Debounce } from 'tachyon-utils-stdlib';
import { debounce } from 'tachyon-utils-stdlib';
import { useUnmount } from '../useUnmount';

export const useDebounce: Debounce = (...args: Parameters<Debounce>) => {
  const { current } = useRef(debounce(...args));

  useUnmount(() => current.cancel());

  return current;
};
