import { renderHook } from '@testing-library/react-hooks';
import { useDebounce } from '.';

const mockCancel = jest.fn();
jest.mock('tachyon-utils-stdlib', () => ({
  ...jest.requireActual('tachyon-utils-stdlib'),
  debounce: () => {
    const fn = () => null;
    fn.cancel = mockCancel;
    return fn;
  },
}));

describe(useDebounce, () => {
  it('cancels when unmounted', () => {
    const { unmount } = renderHook(() =>
      useDebounce(jest.fn(), 0, { trailing: true }),
    );

    expect(mockCancel).not.toHaveBeenCalled();
    unmount();
    expect(mockCancel).toHaveBeenCalledTimes(1);
  });
});
