import type { Dispatch, SetStateAction } from 'react';
import { useState } from 'react';
import type { DebounceOptions } from 'tachyon-utils-stdlib';
import { useDebounce } from '../useDebounce';

/**
 * useState with a debounced setState function
 */
export function useDebouncedState<T>(
  val: T | (() => T),
  waitMs: number,
  opts: DebounceOptions,
): [T, Dispatch<SetStateAction<T>>] {
  const [value, setValue] = useState(val);
  const setDebouncedValue = useDebounce(setValue, waitMs, opts);

  return [value, setDebouncedValue];
}
