import { useState } from 'react';
import { useEffectOnce } from '../useEffectOnce';

export function useDelayed(ms: number): boolean {
  const [show, setShow] = useState(false);

  useEffectOnce(() => {
    const timer = setTimeout(() => {
      setShow(true);
    }, ms);
    return () => clearTimeout(timer);
  });

  return show;
}
