import type { EffectCallback } from 'react';
import { useEffect } from 'react';

/**
 * Helper that avoids the linter automatically filling the dependency list
 * for an effect that is only meant to be run once.
 */
export function useEffectOnce(effect: EffectCallback): void {
  // eslint-disable-next-line react-hooks/exhaustive-deps
  useEffect(effect, []);
}
