import { act, renderHook } from '@testing-library/react-hooks';
import { useEffectOnce } from '.';

describe(useEffectOnce, () => {
  it('only calls effect once despite rerendering', () => {
    const effect = jest.fn();
    const { rerender } = renderHook(() => useEffectOnce(effect));
    expect(effect).toHaveBeenCalledTimes(1);
    act(rerender);
    expect(effect).toHaveBeenCalledTimes(1);
  });

  it('calls cleanup function after unmount', () => {
    const cleanup = jest.fn();
    const effect = jest.fn().mockReturnValue(cleanup);
    const { unmount } = renderHook(() => useEffectOnce(effect));
    expect(effect).toHaveBeenCalled();
    expect(cleanup).not.toHaveBeenCalled();
    act(() => {
      unmount();
    });
    expect(cleanup).toHaveBeenCalled();
  });
});
