import { useEffect } from 'react';

export type ListenerWindow = Pick<
  Window,
  'addEventListener' | 'removeEventListener'
>;

export type ListenerElement = Pick<
  HTMLElement,
  'addEventListener' | 'removeEventListener'
>;

type UseEventTarget = ListenerElement | ListenerWindow;

const defaultTarget = typeof window !== 'undefined' ? window : null;

export const useEvent = <T extends UseEventTarget = Window>(
  name: Parameters<T['addEventListener']>[0],
  handler?: Parameters<T['addEventListener']>[1] | null | undefined,
  target: T | Window | null = defaultTarget,
  options?: Parameters<T['addEventListener']>[2],
): void => {
  useEffect(() => {
    if (!handler || !target) {
      return;
    }

    target.addEventListener(name, handler, options);
    return () => {
      target.removeEventListener(name, handler, options);
    };
  }, [handler, name, options, target]);
};
