import { useReducer } from 'react';

/**
 * Generates an id (to be passed to a child component's key) and a setter. When
 * the setter is invoked, the component will re-render and the child will remount.
 */
export function useForceUpdate(): [number, () => void] {
  return useReducer((prevState: number) => prevState + 1, 0);
}
