import { act, renderHook } from '@testing-library/react-hooks';
import { useForceUpdate } from '.';

describe(useForceUpdate, () => {
  it('triggers a re-render when called', () => {
    let renderCount = 0;
    const { result } = renderHook(() => {
      ++renderCount;
      return useForceUpdate();
    });
    expect(result.current[0]).toEqual(0);
    expect(renderCount).toEqual(1);

    act(() => result.current[1]());
    expect(result.current[0]).toEqual(1);
    expect(renderCount).toEqual(2);
  });

  it('only updates count when called', () => {
    let renderCount = 0;
    const { rerender, result } = renderHook(() => {
      ++renderCount;
      return useForceUpdate();
    });
    expect(result.current[0]).toEqual(0);
    expect(renderCount).toEqual(1);

    act(() => rerender());
    expect(result.current[0]).toEqual(0);
    expect(renderCount).toEqual(2);
  });
});
