// typed copy pasta from dan
// https://overreacted.io/making-setinterval-declarative-with-react-hooks/

import { useEffect } from 'react';
import { useLatest } from '../useLatest';

export function useInterval(callback: () => void, delay: number): void {
  const savedCallback = useLatest(callback);

  // Set up the interval.
  useEffect(() => {
    function tick() {
      savedCallback.current();
    }

    if (delay) {
      const id = setInterval(tick, delay);
      return () => clearInterval(id);
    }
  }, [delay, savedCallback]);
}
