import { useState } from 'react';
import { useEffectOnce } from '../useEffectOnce';

/**
 *
 * Progressive enhancement for when JS is enabled and booted.
 * Used for UI elements that can't do anything until JS boots.
 */
export function useJSEnabled(): boolean {
  const [enabled, setEnabled] = useState(false);
  useEffectOnce(() => setEnabled(true));
  return enabled;
}
