import { act, renderHook } from '@testing-library/react-hooks';
import { useLatest } from '.';

describe(useLatest, () => {
  it('returns the latest value after render', () => {
    const { rerender, result } = renderHook(
      (p) => {
        const ref = useLatest(p);

        // Return both the value as of render time underlying ref
        return {
          ref,
          value: ref.current,
        };
      },
      {
        initialProps: 1,
      },
    );

    // Hook should return 1 during mount and ref
    // should still be 1 after mount completes
    expect(result.current.value).toEqual(1);
    expect(result.current.ref.current).toEqual(1);

    // Hook should return previous value during
    // re-render but should be updated after commit
    act(() => rerender(2));
    expect(result.current.value).toEqual(1);
    expect(result.current.ref.current).toEqual(2);

    act(() => rerender(3));
    expect(result.current.value).toEqual(2);
    expect(result.current.ref.current).toEqual(3);
  });
});
