import { useEffect, useRef } from 'react';
import { useConstCallback } from '../useConst';

// from https://github.com/streamich/react-use/
export function useMountedState(): () => boolean {
  const mountedRef = useRef<boolean>(false);
  const state = useConstCallback(() => mountedRef.current);

  useEffect(() => {
    mountedRef.current = true;

    return () => {
      mountedRef.current = false;
    };
  }, []);

  return state;
}
