import { renderHook } from '@testing-library/react-hooks';
import { useMountedState } from '.';

describe('useMountedState', () => {
  it('should return true if component is mounted', () => {
    const hook = renderHook(() => useMountedState());

    expect(hook.result.current()).toEqual(true);
  });

  it('should return false if component is unmounted', () => {
    const hook = renderHook(() => useMountedState());

    hook.unmount();

    expect(hook.result.current()).toEqual(false);
  });
});
