import type { DependencyList } from 'react';
import { useCallback, useRef } from 'react';
import type { AnyFunction } from 'tachyon-type-library';
import type { PollOpts, PollingFn } from 'tachyon-utils-stdlib';
import { poll } from 'tachyon-utils-stdlib';
import { usePrevious } from '../usePrevious';
import { useUnmount } from '../useUnmount';

export function usePoll<Fn extends AnyFunction>(
  fn: Fn,
  opts: PollOpts,
  deps: DependencyList,
): PollingFn<Fn> {
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const stableFn = useCallback(fn, deps);
  const prevStableFn = usePrevious(stableFn);
  const prevOpts = usePrevious(opts);
  const pollFn = useRef(poll(fn, opts));

  useUnmount(() => pollFn.current.cancel());

  if (
    stableFn !== prevStableFn ||
    opts.intervalMs !== prevOpts.intervalMs ||
    opts.timeoutMs !== prevOpts.timeoutMs
  ) {
    pollFn.current.cancel();
    pollFn.current = poll(fn, opts);
  }

  return pollFn.current;
}
