import { useLatest } from '../useLatest';

export function usePrevious<T>(value: T): T {
  // The ref doesn't get updated until after render (in a useLayoutEffect)
  // so this is always the previous value during the render pass.
  return useLatest(value).current;
}
