import { renderHook } from '@testing-library/react-hooks';
import { act } from 'react-dom/test-utils';
import { usePrevious } from '.';

describe(usePrevious, () => {
  it('returns the previous value as expected', () => {
    const { rerender, result } = renderHook((p) => usePrevious(p), {
      initialProps: 1,
    });
    expect(result.current).toEqual(1);

    act(() => rerender(2));
    expect(result.current).toEqual(1);

    act(() => rerender(3));
    expect(result.current).toEqual(2);
  });
});
