import { useEffect, useRef } from 'react';
import type { Debounce } from 'tachyon-utils-stdlib';
import { throttle } from 'tachyon-utils-stdlib';

export const useThrottle: Debounce = (...args: Parameters<Debounce>) => {
  const { current } = useRef(throttle(...args));

  useEffect(() => current.cancel(), [current]);

  return current;
};
