// dan did it with interval, I'm just adapting it for timeout
// https://overreacted.io/making-setinterval-declarative-with-react-hooks/

import { useEffect } from 'react';
import { useLatest } from '../useLatest';

export function useTimeout(callback: () => void, delay = 0): void {
  const savedCallback = useLatest(callback);

  // Set up the timeout.
  useEffect(() => {
    function onTimeout() {
      savedCallback.current();
    }
    const id = setTimeout(onTimeout, delay);
    return () => clearTimeout(id);
  }, [delay, savedCallback]);
}
