import { useEffectOnce } from '../useEffectOnce';
import { useLatest } from '../useLatest';

/**
 * A helper hook that provides a cleaner way of registering a function to run when
 * a component is unmounted.
 * @param fn The function to run on unmount.
 */
export const useUnmount = (fn: () => any): void => {
  const fnRef = useLatest(fn);

  useEffectOnce(() => () => fnRef.current());
};
